<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormContainerFormMetaField extends Model 
{

    protected $table = 'form_container_form_meta_field';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $visible = array('form_container_id');

    public function controlForm()
    {
        return $this->belongsTo('ControlForm');
    }

    public function formContainer()
    {
        return $this->belongsTo('FormContainer');
    }

    public function formMetaField()
    {
        return $this->belongsTo('FormMetaField');
    }

}